 ; Ŀ
 ;   Tar - centre and middle justify text in boxes.                        
 ;   Also contains Tal - left rejustify and align text in boxes.           
 ;   Copyright 2001, 2002, 2004 - 2006, 2010 by Rocket Software Ltd.       
 ;   Uses parts of Tv.lsp and Teal.lsp, which it must be able to find.     
 ;   Possible rehash: find box borders, then recheck for text.             
 ;                                                                         
 ;   Don't work harder or smarter - have your computer do it.              
 ; 

 ; Ŀ
 ;   Pbd - draw a pseudo-pickbox.                                          
 ;   Arguments: Ppa, a centre point.                                       
 ;              Siz, a size.                                               
 ;   Calls nothing, returns four corner points.                            
 ; 
 (DEFUN PBD (ppa siz / dist ll ul lr ur)
  (setq dist (sqrt (* 2 (/ siz 2) (/ siz 2))))
  (setq ll (polar ppa (* pi 1.25) dist))
  (setq ul (polar ppa (* pi 0.75) dist)) 
  (setq lr (polar ppa (* pi 1.75) dist))
  (setq ur (polar ppa (* pi 0.25) dist))
 ; Ŀ
 ;   We now have the four real corner points of the pickbox.               
 ; 
  (grdraw ll ul -1)
  (grdraw ul ur -1)
  (grdraw ur lr -1)
  (grdraw lr ll -1)
 ; Ŀ
 ;   Force the display to draw the grlines.                                
 ; 
  (princ)
 (list ll ul ur lr))
 ; Ŀ
 ;   Pbd end.                                                              
 ; 

 ; Ŀ
 ;   Pksiz - find the pickbox size in drawing units.                       
 ;   Contains a nameless flaw correction (size is 1/2 what it should be.)  
 ; 
 (DEFUN PKSIZ (/ pbsize vsize scsize pixis)
  (setq pbsize (getvar "pickbox"))       ; pickbox size in pixels
  (setq vsize (getvar "viewsize"))       ; view height in dwg units
  (setq scsize (getvar "screensize"))    ; view ht/wid in pixels
  (setq pixis (/ vsize (cadr scsize)))   ; 1 pixel in dwg units
 (* pbsize pixis 2))                     ; pickbox size in dwg units
 ; Ŀ
 ;   Pksiz end.                                                            
 ; 

 ; Ŀ
 ;   Pksize - primarily for reference - find the pickbox size.             
 ;   This seems to return half of the correct value.                       
 ; 
 (DEFUN C:PKSIZE (/ pbsize vsize scsize a hsize pixy pixx)
  (setq pbsize (getvar "pickbox"))                 ; pickbox size in pixels
  (write-line (strcat "The Pickbox is " (rtos pbsize 2 4) " pixels high."))
  (setq vsize (getvar "viewsize"))                 ; view height in dwg units
  (write-line (strcat "View is " (rtos vsize 2 4) " units high."))
  (setq scsize (getvar "screensize"))              ; view wid & ht in pixels
  (write-line (strcat "View is " (rtos (cadr scsize) 2 4) " pixels high."))
 ; Ŀ
 ;   Find the view width.                                                  
 ; 
  (setq a (/ (car scsize) (cadr scsize)))          ; view width/height ratio
  (write-line (strcat "View width/height ratio is " (rtos a 2 4) "."))
  (setq hsize (* vsize a ))                        ; view width in dwg units
  (write-line (strcat "View is " (rtos hsize 2 4) " drawing units wide."))
  (write-line (strcat "View is " (rtos (car scsize) 2 4) " pixels wide."))
 ; Ŀ
 ;   Pixel and pickbox height.                                             
 ; 
  (setq pixy (/ vsize (cadr scsize)))              ; pixel height
  (write-line (strcat "So one pixel is " (rtos pixy 2 4)
                      " units high."))
  (write-line (strcat "And the pickbox is " (rtos (* pbsize pixy) 2 4)
                      " units high."))
 ; Ŀ
 ;   Find the pickbox width.                                               
 ; 
  (setq pixx (/ hsize (car scsize)))              ; pixel width *** ?
  (write-line (strcat "So one pixel is " (rtos pixx 2 4)
                      " units wide."))
  (write-line (strcat "And the pickbox is " (rtos (* pbsize pixx) 2 4)
                      " units wide."))
 (princ))
 ; Ŀ
 ;   Pksize end.                                                           
 ; 

 ; Ŀ
 ;   Flin - Find the closest line to a point in a given direction.         
 ;   Arguments: Enam1, the base text/attdef entity ename.                  
 ;              Base, the start point.                                     
 ;              Movinc, the distance to move between searches.             
 ;              Dir, the direction to move, in radians.                    
 ;   Stops looking after 1000 tries.                                       
 ;   Calls Siz.                                                            
 ;   Returns a list: a point and the enames of any text or attdefs found,  
 ;   or nil if no lines or other frame entities were found.                
 ; 
 (DEFUN FLIN (enam1 base movinc dir / num ss pop siz txlist typ enam)
  (setq siz (pksiz))
  (setq num 0)
  (while (< num 1000)
         (setq ss (ssget base '((-4 . "<or") (0 . "polyline") (0 . "circle")
                                (0 . "ellipse")
                                (0 . "text") (0 . "attdef") (0 . "insert")
                                (0 . "line") (0 . "lwpolyline") (-4 . "or>"))))
         (if ss (setq typ (cdr (assoc 0 (entget (setq enam (ssname ss 0)))))))
         (cond ((or (= typ "TEXT") (= typ "ATTDEF"))
                (if (not (equal enam enam1))
                    (setq txlist (cons enam txlist))))
               (typ (setq num 2000)))
         (pbd base siz)                   ; indicator
         (setq num (1+ num))
         (if (< num 1000) (setq base (polar base dir movinc))))
  (setq pop (osnap base "nearest"))
  (if pop (setq base pop))
 (if (= num 2001) (cons base txlist) nil))
 ; Ŀ
 ;   Flin end.                                                             
 ; 

 ; Ŀ
 ;   Tbx - text extents locator and outliner.                              
 ; 
 (DEFUN TBX (enam / aa bb rota cc dd bheigt bwidth llangg lldist ll ul lr ur)
  (setq aa (entget enam))
 ; Ŀ
 ;   The textbox function returns...hang on...from the notes below, a      
 ;   list containing the offset of the lower left point of the text from   
 ;   the 10 association point - typically 0,0,0 - and the offset of the    
 ;   upper right point from the ten point.  These are assuming that the    
 ;   text isn't obliqued or rotated, so if it is the program must adjust   
 ;   accordingly.  This program won't bother with obliquing, rotation is   
 ;   allowed.                                                              
 ; 
  (setq bb (textbox aa))
  (setq rota (cdr (assoc 50 aa)))
  (setq cc (car bb))                    ; ll offset from 10 of text
  (setq dd (cadr bb))                   ; ur offset from 10 of text
  (setq bheigt (- (cadr dd) (cadr cc)))
  (setq bwidth (- (car dd) (car cc)))
  (setq llangg (angle (list 0 0) cc))
  (setq lldist (distance (list 0 0) cc))
  (setq ll (polar (cdr (assoc 10 aa)) (+ llangg rota) lldist))
  (setq ul (polar ll (+ rota (/ pi 2)) bheigt))
  (setq lr (polar ll rota bwidth))
  (setq ur (polar lr (+ rota (/ pi 2)) bheigt))
 ; Ŀ
 ;   We now have the real upper left, upper right, etc. points of the      
 ;   text.                                                                 
 ; 
;  (grdraw ll ul -1)
;  (grdraw ul ur -1)
;  (grdraw ur lr -1)
;  (grdraw lr ll -1)
 (list ll ul ur lr))
 ; Ŀ
 ;   Tbx end.                                                              
 ; 

 ; Ŀ
 ;   Subroutine Tar.                                                       
 ;   Arguments: Enam, the entity name of the text entity to realign.       
 ;              Prog, the justification to use (currently M or L).         
 ;   Returns a list of the enames of all new text found.                   
 ; 
 (DEFUN TAR (enam prog / entt txht movinc ptlist ll ur pa incr patop pabase
                         paleft parigt malist ss1 num enam1 ssav midx midy
                           dimscl pamid ptlst2 ul vmid paml pamr pamt pamb)
  (setq entt (entget enam))
  (setq txht (cdr (assoc 40 entt)))
  (setq movinc (* (pksiz) 0.5))
  (setq ptlist (tbx enam))
 ; Ptlist is '(ll ul ur lr)
  (setq ll (car ptlist))
  (setq ur (caddr ptlist))
 ; Ŀ
 ;   Load Misps.lsp, which contains the ps/ms scaling subroutines.         
 ; 
  (if (or (null wasp) (null misps))
      (if (null (load "misps" ()))
          (prompt "\nUnable to load required file Misps.lsp.\n")))
  (setq dimscl (misps))
 ; Ŀ
 ;   Find the midpoint of the text.                                        
 ; 
  (setq pa (list (/ (+ (car ll) (car ur)) 2)
                 (/ (+ (cadr ll) (cadr ur)) 2)))
 ; Ŀ
 ;   Calculate the appropriate line spacing.                               
 ; 
           (setq incr (* 1.65 (cdr (assoc 40 entt))))
 ; Ŀ
 ;   If can find a frame type entity - a line, pline, circle, block, etc.  
 ;   - on each side of the text.                                           
 ; 
  (if (and (setq patop (flin enam pa movinc (/ pi 2)))
           (setq pabase (flin enam pa movinc (* pi 1.5)))
           (setq paleft (flin enam pa movinc pi))
           (setq parigt (flin enam pa movinc 0)))
      (progn
 ; Ŀ
 ;   Check the returned lists for text enames.                             
 ; 
           (if (> (length patop) 1)
               (setq malist (append malist (cdr patop))))
           (if (> (length pabase) 1)
               (setq malist (append malist (cdr pabase))))
           (if (> (length paleft) 1)
               (setq malist (append malist (cdr paleft))))
           (if (> (length parigt) 1)
               (setq malist (append malist (cdr parigt))))
 ; Ŀ
 ;   Extract the boundary point from each returned list.                   
 ; 
           (setq patop (car patop))
           (setq pabase (car pabase))
           (setq paleft (car paleft))
           (setq parigt (car parigt))
 ; Ŀ
 ;   Malist now contains the enames of all new text/attdefs, but not the   
 ;   original one.                                                         
 ;   Add some temporary marker lines.                                      
 ; 
           (grdraw patop parigt 1)  
           (grdraw parigt pabase 1)
           (grdraw pabase paleft 1)
           (grdraw paleft patop 1)
 ; Ŀ
 ;   Make two identical sses, each containing enam and malist.             
 ; 
           (setq ss1 (ssadd enam))
           (setq num 0)
           (while (and malist (setq enam1 (nth num malist)))
                  (setq num (1+ num))
                  (ssadd enam1 ss1))
           (setq ssav (ssadd enam))
           (setq num 0)
           (while (and malist (setq enam1 (nth num malist)))
                  (setq num (1+ num))
                  (ssadd enam1 ssav))
 ; Ŀ
 ;   Call tv to middle rejustify the text/attdefs, respace them            
 ;   vertically, and move their centre point to the middle of the box.     
 ;   Revised - either centre or left justify the text.                     
 ;   Centre it:                                                            
 ; 
           (cond ((= prog "M")
 ; Ŀ
 ;   Find the centre point of the box.                                     
 ; 
                  (setq midx (/ (+ (car paleft) (car parigt)) 2))
                  (setq midy (/ (+ (cadr patop) (cadr pabase)) 2))
                  (setq pamid (list midx midy))
 ; Ŀ
 ;   Centre the text.                                                      
 ; 
                  (tv ss1 ssav pamid incr 1 nil))
 ; Ŀ
 ;   Or left justify it:                                                   
 ; 
                 ((= prog "L")
 ; Ŀ
 ;   Left rejustify the ss.                                                
 ; 
                  (vblxa ss1 (+ (car paleft) (* 2 dimscl)))
 ; Ŀ
 ;   And vertically respace it.                                            
 ; 
                  (vvb ss1 (caddr (assoc 10 (entget (ssname ss1 0)))) incr)
 ; Ŀ
 ;   Get the new corner points, don't outline the text.                    
 ; 
                  (setq ptlst2 (grout ssav nil 0))
 ; Ŀ
 ;   Get the text ss vertical midpoint.                                    
 ; 
                  (setq ul (cadar ptlst2))
                  (setq ll (cadr (nth 3 ptlst2)))
                  (setq vmid (/ (+ ul ll) 2))
(print "ook")
 ; Ŀ
 ;   Move the new ss vetical midpoint to the box vertical midpoint.        
 ; 
                  (setq midy (/ (+ (cadr patop) (cadr pabase)) 2))
                  (command ".move" ssav "" (list 0 vmid) (list 0 midy))))
 ; Ŀ
 ;   Additional section purely for looks.                                  
 ; 
           (setq paml (list (car paleft) (/ (+ (cadr patop) (cadr pabase)) 2)))
           (setq pamr (list (car parigt) (/ (+ (cadr patop) (cadr pabase)) 2)))
           (setq pamt (list (/ (+ (car paleft) (car parigt)) 2) (cadr patop)))
           (setq pamb (list (/ (+ (car paleft) (car parigt)) 2) (cadr pabase)))
           (grdraw paml pamt 1)
           (grdraw pamt pamr 1)
           (grdraw pamr pamb 1)
           (grdraw pamb paml 1)))
 ; Ŀ
 ;   Return the enames of all text found, except the original entity.      
 ; 
 malist)
 ; Ŀ
 ;   Subroutine Tar end.                                                   
 ; 

 ; Ŀ
 ;   Tara.                                                                 
 ; 
 (DEFUN TARA (prog / blip osmo *error* ss enam malist)
  (command "undo" "be")
  (setq blip (getvar "blipmode"))
  (setvar "blipmode" 0)
  (setq osmo (getvar "osmode"))
  (setvar "osmode" 0)
 ; Ŀ
 ;   Make an error handler.                                                
 ; 
  (defun *error* (shk)
   (setvar "osmode" osmo)
   (setvar "blipmode" blip)
   (command "undo" "end")
   (if shk (print shk))
  (princ))
 ; Ŀ
 ;   Ask for an ss.                                                        
 ; 
  (setq ss (ssget (list (cons 0 "text,attdef"))))
  (while (and ss (setq enam (ssname ss 0)))
         (ssdel enam ss)
         (if (setq malist (tar enam prog))
 ; Ŀ
 ;   If any new text entities were found, Remove them from ss.             
 ; 
             (while (setq enam (car malist))
                    (setq malist (cdr malist))
                    (ssdel enam ss))))
  (setvar "blipmode" blip)
  (setvar "osmode" osmo)
  (command "undo" "end")
 (princ))
 ; Ŀ
 ;   Tara end.                                                             
 ; 

 ; Ŀ
 ;   Tal.                                                                  
 ; 
 (DEFUN C:TAL ()
  (if (load "Teal" nil)
      (tara "L")
      (prompt "Unable to load required file Teal.lsp"))
 (princ))

 ; Ŀ
 ;   Tar.                                                                  
 ; 
 (DEFUN C:TAR ()
 ; Ŀ
 ;   If Tv is available...                                                 
 ; 
  (if (load "Tv" nil)
      (tara "M")
      (prompt "Unable to load required file Tv.lsp"))
 (princ))